/*----------------------------------------------------------------------
 | VAR.H							940420
 |
 | Contains all global procedure prototypes and variable prototypes.
 +----------------------------------------------------------------------*/


#include "macro.h"

#ifdef _WIN32
#define CDECL __cdecl
#else
#define CDECL
#endif


/* ab.c */
extern void     Search(Signed1 depth, MoveType * move, ValueType * value);
extern void     FreePath(PathType * path);

/* command.c */
extern Signed2  InterpretCommand(char *command);
extern void     PerformMoveCommand(char *moveString);
extern void     PerformPlacePiece(char *pieceString);

/* diskio.c */
extern void     SaveGame(char *filename);
extern void     LoadGame(char *filename);
extern void     SaveLatexPos(char *filename);

/* evaluate.c */
extern ValueType Evaluate(Signed1 ttDepth, ValueType ttValue, Unsigned1 flag,
                                          Unsigned4 ttNodes);

/* generate.c */
extern void     GenerateMoves(MoveType ** moveList, Unsigned1 * nrMoves);
extern Boolean  Attacked(BoardIndexType square, SquareType color);
#ifdef Bcc
extern Boolean  FindFirstPieceInDir(Unsigned1 max,
                   BoardIndexType huge * table, PieceType * attackingPiece);
#else
extern Boolean  FindFirstPieceInDir(Unsigned1 max, BoardIndexType * table,
                                                PieceType * attackingPiece);
#endif
extern void     SearchForPinsAndCheck(void);
extern void     GenerateCaptureMoves(CheckPieceType * piece, MoveType * list,
                                                     Unsigned1 * nrMoves);
extern void     GenerateInterposingMoves(CheckPieceType * piece, MoveType * list,
                                                       Unsigned1 * nrMoves);
extern void     GenerateKingMoves(BoardIndexType square, MoveType * list,
                                                  Unsigned1 * nrMoves);
extern Signed2  CompareMoves(MoveType * move1, MoveType * move2);
extern void     HeapSort(MoveType * moveList, Unsigned1 nrMoves);
extern void     SiftDown(MoveType * moveList, Unsigned1 root, Unsigned1 leaf);

/* init.c */
extern void     Init(void);
extern void     EmptyBoard(void);
extern void     StartingPosition(void);
extern void     PlacePiece(SquareType piece, BoardIndexType square);
extern void     ClearHistoryTables(void);
extern void     ClearPieceSquareTables(void);
extern void     InitPositionalValue(void);
extern void     InitTransTable(void);

/* io.c */
extern void     PrintBoard(void);
extern void     PrintMoveList(MoveType * list, Unsigned1 nrMoves);
extern void     PrintAllocVariables(void);
extern void     PrintGame(Signed2 from, Signed2 to);
extern void     PrintPath(PathType * path);
extern void     PrintHistoryTable(void);
extern void     PrintHashes(void);
extern void     PrintSettings(void);
extern void     PrintTestSettings(Signed2 testDepth, Signed2 testColor,
                                                  Signed4 testNrNodes);

/* move.c */
extern void     DoMove(MoveType * move);
extern void     UndoMove(void);

/* quies.c */
extern ValueType Quiescence(ValueType alpha, ValueType beta,
                   PathType ** bestPath, Signed1 ttDepth, ValueType ttValue,
                                         Unsigned1 flag, Unsigned4 ttNodes);

/* search.c */
extern void     PreProcessing(void);
extern Signed2  ItIsADraw(void);

/* testing.c */
extern void     TestArguments(int argc, char *argv[]);


extern BoardIndexType lastMovedPieceSquare;
extern Unsigned1 nrCheck;
extern CheckPieceType checkingPiece[2];
extern DirectionType pinned[H8 + 1];
extern SquareType board[NrSquares];
extern BoardIndexType epSquare[MaxGamePlies];
extern Unsigned1 castling[MaxGamePlies];
extern HashType hashValue[MaxGamePlies];
extern Unsigned2 startHashIndex[MaxGamePlies];
extern SquareType toMove;
extern Unsigned4 material[2];
extern ValueType positionalValue[2];
extern Unsigned2 pieceValue[128];
extern char     pieceSymbol[256];
extern PieceType pieces[2][16];
extern Unsigned1 nrPieces[2];
extern Unsigned1 pieceIndex[H8 + 1];
extern BoardIndexType kingSquare[2];
extern char     gameString[MaxGamePlies][MaxMoveLength];
extern MoveType game[MaxGamePlies];
extern Unsigned2 nrGamePlies,
                maxGamePlies;
extern Unsigned2 startPly;
extern SquareType computer;
extern Unsigned4 nrInternalNodes,
                nrLeafNodes,
                nrQuiesNodes;
extern Unsigned4 nrIllegalMoves;
extern Unsigned4 nrTotalNodes,
                nrExtraNodes;
extern double   startingTime;
extern Unsigned2 nrAllocMoveLists,
                nrAllocPathMoves;
extern Boolean  stopSearching;
extern char    *moveColorString[2];
#ifdef Bcc
extern huge Unsigned2 historyTable[2][H8 + 1][H8 + 1];
#else
extern Unsigned2 historyTable[2][H8 + 1][H8 + 1];
#endif
extern Signed2  pawnEvalTable[2][H8 + 1];
extern Signed2  knightEvalTable[2][H8 + 1];
extern Signed2  bishopEvalTable[2][H8 + 1];
extern Signed2  rookEvalTable[2][H8 + 1];
extern Signed2  queenEvalTable[2][H8 + 1];
extern Signed2  kingEvalTable[2][H8 + 1];
extern Signed2  centreTable[H8 + 1];
extern Boolean  interActive,
                doTest,
                useTransTable,
                useRefTable;
extern Boolean  useTwoLevelTable,
                useTtValue,
                useTtMove,
                timeStamp;
extern Boolean  useFlag;
extern char    *version;
extern TtEntry *transTable;
extern Unsigned4 nrCollisions,
                nrHits,
                nrReads,
                nrWrites;
extern Signed4  testNrNodes;
extern Unsigned1 nrTtBits;
extern Unsigned2 keepPly;
extern Unsigned1 keepMethod;
extern char    *methodString[5];
extern Unsigned2 debugDepth;

extern char    *logicString[2];

extern Unsigned1 packPiece[Edge];
extern SquareType unpackPiece[4];       /* 2 bits */
extern Unsigned1 packSquare[H8 + 1];
extern BoardIndexType unpackSquare[64]; /* 6 bits */
extern Unsigned1 packType[64];
extern Unsigned1 unpackType[8]; /* 3 bits */

#ifdef Bcc
extern huge BoardIndexType knightTable[H8 + 1][MaxKnightMoves];
extern huge BoardIndexType bishopTable[H8 + 1][4][MaxBishopMoves];
extern huge BoardIndexType rookTable[H8 + 1][4][MaxRookMoves];
extern huge BoardIndexType pawnMoveTable[2][H8 + 1][2];
extern huge BoardIndexType pawnCaptureTable[2][H8 + 1][2];
#else
extern BoardIndexType knightTable[H8 + 1][MaxKnightMoves];
extern BoardIndexType bishopTable[H8 + 1][4][MaxBishopMoves];
extern BoardIndexType rookTable[H8 + 1][4][MaxRookMoves];
extern BoardIndexType pawnMoveTable[2][H8 + 1][2];
extern BoardIndexType pawnCaptureTable[2][H8 + 1][2];
#endif

extern DirectionType knightDir[8],
                bishopDir[4],
                rookDir[4];
extern DirectionType pawnCaptureDir[2][2];

extern char    *commandString[MaxCommands][2];

extern HashType pawnHashTable[2][H8 + 1];
extern HashType knightHashTable[2][H8 + 1];
extern HashType bishopHashTable[2][H8 + 1];
extern HashType rookHashTable[2][H8 + 1];
extern HashType queenHashTable[2][H8 + 1];
extern HashType kingHashTable[2][H8 + 1];
extern HashType movedHash;
extern HashType enPassantHashTable[H + 1];
extern HashType castlingHashTable[2][2];

extern Boolean  printDebug;
extern Unsigned4 nrMovesGenerated,
                nrGenerates;
